/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
*  Beck Computer-Loesungen GmbH
*  Garbenheimer Str. 30-38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
*
* ATTENTION : This library will only work with BC01-Firmware V1.10 and above
*
* ---------------------------------------------------------------------------
* Module        :    BC01.H
* Function      :    Prototypes & defines BC01.C
* Author        :    vb/dg/tw
* Date          :    10.06.97
* Version       :    1.10
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  0.01   11.02.97   vb     first version
*  0.02   20.02.97   vb     run/stop-switch,version,platform
*  0.03   21.02.97   vb     watchdog-mode, error A/B-direction,
*							all-disable(Trimmer,fast_counter,A/B-detection)
*  0.04   26.02.97   vb     Interrupt-Counter-Entry Functions
*							(enable,disable,getvect,setvect)
*							A/B-Position-Drive
*			 			   	Deinit fast counter
*							ab-init,ab-deinit,interrupt-deinit,
*							ab-reset, fast_counter-reset
*  0.05   28.02.97   vb     fast_count-on,fast_count-off
*  0.06   18.04.97   dg     renamed to BC01.H
*							remote functions added
*                           bit to byte conversion added
*                           process image structures and procedures added
*  1.10   10.06.97   tw     header file completed last prototypes added
*
*****************************************************************************/

// number of digital inputs
#define MAX_INPBITS 12
// number of digital inputs bytes
#define MAX_INPBYTES 2
// number of digital outputs
#define MAX_OUTBITS 8
// number of digital output bytes
#define MAX_OUTBYTES 1
// number of remote stations
#define MAX_REMOTE 1
// number of remanent flags words (maximum = 1024)
#define MAX_FLAGS 128
// max. number of areas in hc0x_rentop_type
#define MAX_RENT_ENTRIES 1
// max. number of fast counters (hardware counter)
#define MAX_COUNTER 2
// max. number of timers (0..9)
// timer 0 is always used by for cycle time control
#define MAX_TIMER 10

// defines
#define UCHAR unsigned char
#define UINT unsigned int
#define BOOL int
#define BYTE unsigned char
#define WORD unsigned int
#define DWORD unsigned long
#define FALSE 0
#define TRUE 1

// byte-array for byte to bit conversion
//typedef int Byte_Type[8];

// counter configuration
typedef struct
{
	BOOL Enable;
	WORD Max;
	WORD Mode;		// 0=single / 1=continous
} Cfg_Counter_Type;

// timer configuration
typedef struct
{
	BOOL Enable;
	int Handle;
	WORD Prescale;
} Cfg_Timer_Type;

// process image configuration
typedef struct
{
	// fast counter configuration
	Cfg_Counter_Type Counter[MAX_COUNTER];
	// timer configuration
	Cfg_Timer_Type Timer[MAX_TIMER];
	// cycles timer
	Cfg_Timer_Type Cycle;
	// convert input-byte to input-bits and
	// convert output-bits to output-byte
	BOOL BitArrayEnable;
	// a/b incremental counter enable
	BOOL AB_Enable;
	// adjustment trimmer enable
	BOOL TrimmerEnable;
	// enable watchdog function
	BOOL WatchdogEnable;
	// active remote stations and status
	int Remote;
	int RemoteStat;
	// define cycle time in units of 55 ms
	int CycleTime;
} BC01_Cfg_Type;

typedef struct
{
	BYTE E_Byte[MAX_INPBYTES];
	BYTE E_Bit[MAX_INPBITS];
	int RunStop;
} E_Remote_Type;

typedef struct
{
	BYTE A_Byte[MAX_OUTBYTES];
	BYTE A_Bit[MAX_OUTBITS];
} A_Remote_Type;

typedef struct
{
	BYTE E_Byte[MAX_INPBYTES];
	BYTE E_Bit[MAX_INPBITS];
	int RunStop;
	WORD Count[2];
	DWORD Timer[MAX_TIMER];
	BYTE Trimmer;
	E_Remote_Type Remote[MAX_REMOTE];
} E_Type;

typedef struct
{
	BYTE A_Byte[MAX_OUTBYTES];
	BYTE A_Bit[MAX_OUTBITS];
	BYTE Led;
	A_Remote_Type Remote[MAX_REMOTE];
} A_Type;

// retentive flags
typedef union
{
	BYTE M_Byte[MAX_FLAGS*2];		// byte access
	WORD M_Word[MAX_FLAGS];			// word access
} M_Type;

// structure for retentive operators/flags
typedef struct
{
	unsigned int Entries;		// number of entries in remop_entry
	unsigned int Segment;		// common segment address
	struct BC01_RentOp_Entry
	{
		unsigned int Offs;		// offset adress
		unsigned int Size;		// number of bytes (must be <= maxsize)
		unsigned int MaxSize;	// maximal number of bytes
		unsigned int ElemSize;	// number ob bytes per data-element
		unsigned int Distance;	// distance to next data element
	} x[MAX_RENT_ENTRIES];
} BC01_RentOp_Type;

typedef BYTE Timer_Type[10];

// led states
#define LED_OFF 0
#define LED_GREEN 1
#define LED_RED 2
#define LED_ORANGE 3
#define LED_BLINK 4

// communication

#define BC01_DEV_CON 0
#define BC01_DEV_EXT 1
#define BC01_DEV_COM 2

#define BC01_COM_EXT 0
#define BC01_COM_COM 1

/****************************************************************************
*
* Start of BC01/BC02 low-level BIOS and service-interrupt functions
*
*****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read hc0x/bc0x version information
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : version_data_ligth_bios:int *  (out hexadecimal)
*                 version_bc0x_firmware: int *    (out hexadecimal)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  20.02.97   vb     first
****************************************************************************/

void BC01_GetVersion(int *VersBios,int *VersBC01);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Hardware platform detection
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : platform : char *
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 20.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  20.02.97   vb     first version
****************************************************************************/

void BC01_GetPlatform(char *Platf);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Get Serial number of BC01
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : Serial : char * : if not avail or not programmed Serial is
*									"000000"
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : tw
* Last Changes  : 10.06.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  10.06.97   vb     first version
****************************************************************************/

void BC01_GetSerial(char *Serial);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : user watchdog on
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   11.02.97  vb     first
****************************************************************************/

void BC01_Watchdog_SetUser(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : user watchdog refresh
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   11.02.97  vb     first
****************************************************************************/

void BC01_Watchdog_Refresh(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : switch back to BIOS watchdog
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   11.02.97  vb     first
****************************************************************************/

void BC01_Watchdog_SetBios(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read watchdog mode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : watchdog mode:int   (2|3)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   21.02.97  vb     first
****************************************************************************/

int BC01_Watchdog_GetMode(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set LED
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : number: int  (0..7)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 21.02.97
* Version       : 1.01
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*   1.00  11.02.97  vb     first
*   1.01  21.02.97  vb     set_LED
****************************************************************************/

void BC01_Led_Write(int value);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read LED status
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : -/-
* Return        : number: char
* Header-File   :  BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 21.02.97
* Version       : 1.01
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*   1.00  11.02.97  vb     first
*   1.01  21.02.97  vb     read_LED_status
****************************************************************************/

int BC01_Led_Read(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read run/stop switch
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : switch-position:int      (0|1)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  :  20.02.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  20.02.97   vb     first
****************************************************************************/

int BC01_RunStop_Read(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read digital input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : read-category:int(0-Byte,1-Word Hi-Byte=0, 2-Word Hi-Byte=1),
*		  destination-buffer:unsigned char pointer
*                 read-bytes-number:int (= length destination-buffer)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.01
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void BC01_Inputs_Read(void *buffer, int size);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Write to out
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : write-category: int ( 0-Byte,1-Word ),
*				  source-buffer: unsigned char pointer ,
*				  write-bytes-number:int (= length source-buffer)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void BC01_Outputs_Write(void *buffer, int size);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : get number of fast counters
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : -/-
* Return        : number:int     (2)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*   1.00  11.02.97  vb      first version
****************************************************************************/

int BC01_FastCounter_Info(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : enable fast counters
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 28.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  28.02.97  vb      first version
****************************************************************************/

void BC01_FastCounter_Enable(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : disable fast counters
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   :  BC01.H
* ---------------------------------------------------------------------------
* Author        : vb/dg
* Last Changes  : 28.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  28.02.97  vb      first version
****************************************************************************/

void BC01_FastCounter_Disable(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : init fast counter
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : couunter: int            (counter number),
*                 mode: int                (0-single|1-continious),
*                 max : unsigned int       (max. counter value)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb      first
****************************************************************************/

void BC01_FastCounter_Init(int n, int mode, WORD max);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : deinit fast counter
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : counter number: int     (0|1),
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb      first
****************************************************************************/

void BC01_FastCounter_Deinit(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : start fast counter
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : counter number:int (0|1)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.07
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97  vb      first version
****************************************************************************/

void BC01_FastCounter_Start(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : stop fast counter
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : counter number: int (0|1)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb      first version
****************************************************************************/

void BC01_FastCounter_Stop(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read fast counter value
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : counter number:int    (0|1)
* Return        : counter position: unsigned int
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb      first
****************************************************************************/

WORD BC01_FastCounter_Read(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : reset fast counter to zero
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : counter number:int (0|1)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97  vb      first
****************************************************************************/

void BC01_FastCounter_SetZero(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : trimmer on
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void BC01_Trimmer_Enable(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : trimmer off
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC0X.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void BC01_Trimmer_Disable(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read trimmer value
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : adjust position: int
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

int BC01_Trimmer_Read(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : initalize A/B incremental counter
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : zerovalue: int
* Return        :    -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   26.02.97  vb      first
****************************************************************************/

void BC01_ABcount_Init(int ZeroValue);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : deinitalise A/B incremental counter
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   26.02.97  vb      first
****************************************************************************/

void BC01_ABcount_Deinit(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set A/B incremental counter to zerovalue
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   26.02.97  vb      first version
****************************************************************************/

void BC01_ABcount_Reset(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read A/B incremental counter value
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : error: int *     (0 no error, 1 overflow , -1 underflow)
* Return        : counter-position: int
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb      first
****************************************************************************/

int BC01_ABcount_Read(int *error);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read A/B incremental counter direction
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : -/-
* Return        : direction-position:int    (0|1 example 0-A 1-B)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97  vb      first version
****************************************************************************/

int BC01_ABcount_ReadDirection(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set A/B reference
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : number :int   (0-7),
				  bit0: 0=no reference setting / 1=reference setting
				  bit1: 0=set ref. only one time / 1=allways set ref.
				  bit2: 0=set ref. on direction=0 / 1=set ref. on direction=1
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  09.06.97   dg     first
****************************************************************************/

void BC01_ABcount_SetReferenceMode(int ReferenceMode);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : disable A/B incremental counter
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   11.02.97  vb     first version
****************************************************************************/
/*
void BC01_ABcount_Off(void);
*/

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : check if remote driver REO.EXE is installed
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : int	0 = host
						1 = remote
						-1 = stand-alone (not initialised)
						-2 = driver not installed
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  21.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  18.04.97   dg     first version
****************************************************************************/

int BC01_Remote_Installed(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : initialise remote driver and set to master mode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : remote_count: int
* Return        : int (1=no error / 0=error - slaves not found)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  18.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  18.04.97   dg     first version
****************************************************************************/

int BC01_Remote_Init(int remote_count);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read run/stop switch, local and remote
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : remote:int (0=local, 0xFF0n=remote, n=0..2)
* Return        : switch-position:int      (0|1)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  18.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  18.04.97   dg     first
****************************************************************************/

int BC01_RunStop_ReadRemote(int remote);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read local and remote inputs
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : read-category:int(0-Byte,1-Word Hi-Byte=0, 2-Word Hi-Byte=1),
*					   destination-buffer:unsigned char pointer
*                 read-bytes-number:int (= length destination-buffer)
*						remote:int (0=local, 0xFF0n=remote, n=0..2)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 18.04.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  19.04.97   dg     first version
****************************************************************************/

void BC01_Inputs_ReadRemote(void *buffer, int size, int remote);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : write to digital output (local and remote)
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : write-category: int ( 0-Byte,1-Word ),
*				  source-buffer: unsigned char pointer ,
*				  write-bytes-number:int (= length source-buffer)
*				  remote:int (0=local, 1..3=remote)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  18.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  18.04.97   dg     first
****************************************************************************/

void BC01_Outputs_WriteRemote(void *buffer, int size, int remote);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read number of interrupt inputs
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : number:int      (2)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

int BC01_IntrInputs_Info(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : configure input E1.n as interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number: int    (0|1)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first version
****************************************************************************/

void BC01_IntrInputs_Enable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : configure E1.n as standard digital input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number: int    (0|1)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first
****************************************************************************/

void BC01_IntrInputs_Disable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read interrupt vector for interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number: int         (0|1)
* Return        : pointer :void interrupt  (oldhandler)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void interrupt (*BC01_IntrInputs_GetVect(int n))(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set interrupt service routine for interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number:int   (0|1),
*                 pointer :void interrupt      (handler)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void BC01_IntrInputs_SetVect(int n, void interrupt (*handler)());

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : enable interrupt for interrupt input E1.n
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : input number:int (0|1)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void BC01_Interrupt_Enable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : disable interrupt for interrupt input E1.n
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number: int (0|1)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void BC01_Interrupt_Disable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : trimmer off, fast counter off, A/B incremental counter off
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 21.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  21.02.97   vb     first version
****************************************************************************/

void BC01_DisableAll(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : enable interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : entry-number   (0|1)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first version
****************************************************************************/

void BC01_IntrCount_Enable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : disable interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : entry-number   (0|1)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first
****************************************************************************/

void BC01_IntrCount_Disable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : get pointer to service routine of interrupt input n
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : entry-number: int (0|1)
* Return        : pointer :void interrupt   (oldhandler)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first
****************************************************************************/

void interrupt(*BC01_IntrCount_GetVect(int n))(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set service routine for interrupt input n
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : entry-number :int   (0|1),
*                 pointer : void interrupt      (handler)
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first
****************************************************************************/

void BC01_IntrCount_SetVect(int n,void interrupt (*handler)());

//*************************************************************************
//
//  Timer/Counter-Services
//
/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : check if timer/counter avset service routine for interrupt input n
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : int: 0=not available, 1=available
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 30.04.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  30.04.97   dg     first version
****************************************************************************/

int BC01_Timer_Installed(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : enable timer service
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : TimerType *Buffer: pointer to timer buffer
*               : int n: number of timer
* Return        : int: 0=no error, 1=error
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL BC01_Timer_Enable(Timer_Type *Buffer, int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : disable timer service
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : TimerType *Buffer: pointer to timer buffer
*               : int n: number of timer
* Return        : int: 0=no error, 1=error
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

void BC01_Timer_Disable(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : insert a new 32 bit timer
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int ContMode
*               : int IncMode
*               : WORD Prescale
* Return        : int: handle (timer number)
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

int BC01_Timer_Insert(int ContMode, int IncMode, WORD Prescale);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set timer increment mode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
*               : int IncMode: count mode
* Return        : BOOL: 0 = error, 1 = ok
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

int BC01_Timer_SetIncr(int Handle, int IncMode);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : get timer periode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: 0 = error, >0 = prescale value
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

WORD BC01_Timer_GetPrescale(int Handle);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set timer periode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
*               : WORD Prescale: prescale value
* Return        : BOOL: 0 = error, 1 = ok
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL BC01_Timer_SetPrescale(int Handle, WORD Prescale);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : start timer
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: 0 = error, 1 = ok
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL BC01_Timer_Start(int Handle);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : stop timer
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: 0 = error, 1 = ok
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL BC01_Timer_Stop(int Handle);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read timer value
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: timer value, 0xFFFF = error
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

DWORD BC01_Timer_Read(int Handle);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read timer value
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: timer value, 0xFFFF = error
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL BC01_Timer_Write(int Handle, DWORD Value);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set timer interrupt routine
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int CntrMode:
*               : WORD Prescale:
*               : void interrupt (*handler)()): pointer to interrupt routine
* Return        : int:
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

int BC01_TimerIntr_SetVect(int CntrMode,WORD Prescale,
						   void interrupt (*handler)());

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : get BIOS timer value, 55ms = 18.2 hertz
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : long:
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

long BC01_BiosTimer_Get(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : wait until BIOS timer reaches the value biostime+wait
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : long: BiosTime
*				  int: Wait
* Return        : int:
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

int BC01_BiosTimer_Wait(long biostime, int wait);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : wait for n BIOS-timer ticks
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Ticks
* Return        : -/-
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 27.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  27.05.97   dg     first version
****************************************************************************/

void BC01_BiosTimer_Delay(int Ticks);

/****************************************************************************
*
* Start of high-level hc0x/bc0x functions
*
*****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : convert byte-array to bit-array
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : bits: int  (bit array)
* Return        : bytes: typebyte (byte array)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  19.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  19.04.97   dg     first
****************************************************************************/

void BC01_InputsToBit(void *InpBytes, void *InpBits, int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : convert bit-array to byte-array
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : bytes: typebyte (byte array)
* Return        : bits: int (bit array)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  19.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  19.04.97   dg     first version
****************************************************************************/

void BC01_OutputsToByte(void *OutBits, void *OutBytes, int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : define and read retentive flags from flash memory
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : size: int (number of flags words)
*               : m: M_type  (retentve flags)
* Return        : int (0=error, 1=ok)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  27.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  27.04.97   dg     first version
****************************************************************************/

int BC01_Flags_Init(void *M, int size);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : write retentive flags to flash memory
*				  uses values from BC01_Flags_Read
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : int (0=error, 1=ok)
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 29.04.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  27.04.97   dg     first version
****************************************************************************/

int BC01_Flags_Write(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : reset BC01_Cfg
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 09.06.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  09.06.97   dg     first version
****************************************************************************/

void BC01_Image_CfgClr(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Initialize process image
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Image_Init(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Deinitialize process image
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Image_Deinit(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Read process image
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Image_Read(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Put Image bits into bit-array
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Image_InputToBits(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Write process image
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Image_Write(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Put output bits form bitarray into byte
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Image_OutputToByte(void);

//********************************************************************
//
//  BC01/BC0x Console I/O
//
//********************************************************************

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Set baud rate for com port
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Port			Portnr
*				  int: Baud			Baudrate
*				  int: Parity		Parity
*				  int: Datenbits	Databits
*				  int: Stopbits		Stopbits
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

int BC01_Com_SetBaud(int Port,int Baud,int Parity,int Datenbits,int Stopbits);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Initialize com port
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: port
* Return        : BOOL:
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

BOOL BC01_Com_Init(int Port);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Get Char from Console
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
* Return        : int:
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

int BC01_GetChar(int Channel);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Put char to console
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
*				  int: c
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_PutChar(int Channel, int c);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Put string to  console
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
*				  char: *s string
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_PutStr(int Channel, char *s);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set cursor to position x,y with ANSI codes
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
*				  BYTE: x
*				  BYTE: y
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Ansi_CrsrXY(int Channel, BYTE x, BYTE y);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Set cursor in upper left corner of screen with ANSI-codes
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Ansi_CrsrHome(int Channel);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Clear screen with ANSI-codes
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Ansi_ClrScr(int Channel);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Clear to end of Line with ANSI-codes
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
* Return        : -
* Header-File   : BC01.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void BC01_Ansi_ClrEol(int Channel);

/****************************************************************************
* END OF BC01.H
****************************************************************************/
