/* Bibliothque de dialogue pour port srie sur api LEROY */
/* (C)opyright 1997 IRAI */
/* TURBOC - MODEL SMALL */
// 19/03/1997

#include "\lt_prog\include\prosimp.h"
#include "\lt_prog\include\constser.h"
#include "\lt_prog\include\paramser.h"

#define lcombuffe 2048
#define lcombuffr 2048

TParametreSerie ParamCom;
TProtocoleSimple Protocole;
unsigned port;

/* Configure le port srie, initialise le port, les buffers et les it   */

/* En entre :  - comport=  xy x=it, y=port (14)                       */
/*              - speed=    vitesse en bauds                            */
/*              - parity=   'O|E|N|M|S'                                 */
/*              - stopbit=  1 ou 2                                      */

/* En sortie :  - 0 =       ok                                          */
/*              - -1=       port invalide ou non install               */
/*              - -2=       configuration non valide                    */

int comint_config(  unsigned comport,
                    unsigned long speed,
                    unsigned parity,
                    unsigned databit,
                    unsigned stopbit)
{
unsigned speedcode,paritycode,stopcode,datacode;
switch(speed)
	{
	case 115200: speedcode=Baud115K; break;
	case 76800: speedcode=Baud76800; break;
	case 38400: speedcode=Baud38400; break;
	case 19200: speedcode=Baud19200; break;
	case 9600: speedcode=Baud9600; break;
	case 4800: speedcode=Baud4800; break;
	case 2400: speedcode=Baud2400; break;
	case 1200: speedcode=Baud1200; break;
	case 600: speedcode=Baud600; break;
	case 300: speedcode=Baud300; break;
	case 150: speedcode=Baud150; break;
	case 110: speedcode=Baud110; break;
	case 75: speedcode=Baud75; break;
	default : return -2;
	}
switch(parity)
	{
	case 'O' : paritycode=PariteImpaire; break;
	case 'E' : paritycode=ParitePaire; break;
	case 'N' : paritycode=SansParite; break;
	case 'S' : paritycode=PariteForceA0; break;
	case 'M' : paritycode=PariteForceA1; break;
	default : return -2;
	}
switch(stopbit)
	{
	case 1 : stopcode=Stop1Bit; break;
	case 2 : stopcode=Stop2Bit; break;
	default : return -2;
	}
switch(databit)
	{
	case 5 : datacode=Donnee5Bit; break;
	case 6 : datacode=Donnee6Bit; break;
	case 7 : datacode=Donnee7Bit; break;
	case 8 : datacode=Donnee8Bit; break;
	default : return -2;
	}
if(InitProtocoleSimple(&Protocole,comport,lcombuffe,lcombuffr)!=1)
	{
	return -1;
	}
ParamCom.Vitesse=speedcode;
ParamCom.Parite=paritycode;
ParamCom.Stop=stopcode;
ParamCom.Donnee=datacode;

if(ParametrageLiaisonSerie(comport,&ParamCom)==0)
	{
	CloseProtocoleSimple(&Protocole);
	return -1;
	}
port=comport;
return 0;
}

/* rinitialise le port srie */

void comint_reset()
{
ParametrageLiaisonSerie(port,&ParamCom);
}

void comint_resetbuff()
{
ParametrageLiaisonSerie(port,&ParamCom);
}


/* Fin d'utilisation du port srie, annule l'utilisation des its */

void comint_stopcom()
{
CloseProtocoleSimple(&Protocole);
}


/* envoie le caractre c */
void comint_putcom(unsigned char c)
{
EmissionCaractere(&Protocole,c);
}

/* envoie le buffer b d'une longueur l*/
void comint_putbuffcom(unsigned char *b,unsigned l)
{
EmissionCaracteres(&Protocole,b,l);
}

int charinbuff;
unsigned char cbuff;


/* Retourne un char ou -1 si pas de char disponibles */
int comint_getcom()
{
int result=0;
if(charinbuff)
    {
    result=cbuff;
    charinbuff=0;
    }
else
    {
    if(ReceptionCaractere(&Protocole,(unsigned char *)&result)==0) return -1;
    }
return result;
}


/* Retourne 1 si un char est disponible, 0 autrement */
int comint_ischar()
{
if(charinbuff) return 1;
if(ReceptionCaractere(&Protocole,&cbuff)==0)
    {
    return 0;
    }
charinbuff=1;
return 1;
}

/*
// Retourne 1 si au moins un char reste  mettre
int comint_ischarout(void)
{
return 0;
}
*/
/*
void comint_setbreak()
{
unsigned char stoctrl;
unsigned char stoport;
#if defined(RTSNORMAL) || defined (RTSINVERT)
stoport=inportb(adcom+4);
#ifdef RTSNORMAL
outportb(adcom+4,stoport|2);
#else
outportb(adcom+4,stoport&0xfd);
#endif
#endif
stoctrl=inportb(adcom+3);
outportb(adcom+3,stoctrl|0x40);
}




void comint_resetbreak()
{
unsigned char stoctrl;
unsigned char stoport;
stoctrl=inportb(adcom+3);
outportb(adcom+3,stoctrl&0xbf);
#if defined(RTSNORMAL) || defined (RTSINVERT)
stoport=inportb(adcom+4);
#ifdef RTSNORMAL
outportb(adcom+4,stoport&0xfd);
#else
outportb(adcom+4,stoport|2);
#endif
#endif
}

void comint_setrts(unsigned state)
{
unsigned char stoport;
stoport=inportb(adcom+4);
if(state)
    {
    outportb(adcom+4,stoport|2);
    }
else
    {
    outportb(adcom+4,stoport&0xfd);
    }
}

void comint_setdtr(unsigned state)
{
unsigned char stoport;
stoport=inportb(adcom+4);
if(state)
    {
    outportb(adcom+4,stoport|1);
    }
else
    {
    outportb(adcom+4,stoport&0xfe);
    }
}
*/
