// Paramtrage des applications gnres par le post-processeur C
// AUTOMGEN V6 - (C)opyright 2000 IRAI

// #define HC01    // Doit tre dfini pour l'automate FESTO HC01
// #define HC01EXT // Doit tre dfini si l'automate HC01 possde une extension
// #define FEC     // Doit tre dfini pour l'automate FEC de FESTO
// #define FECEXT  // Doit tre dfini si l'automate FEC possde une extension

// #define LT		// Doit tre dfini pour les automates LT de LEROY AUTOMATISME

// Dfinition du nombre de variables
#define NINPUT 128
#define NOUTPUT 128
#define NBIT 1024
#define NWORD 1024
#define NDWORD 1024
#define NFLOAT 1024

// Paramtrage du mode de debug  distance
// Ce mode ncessite de lier les module RDEBUG et COMINT

#define RDEBUG			// Valide le mode de debug  distance

// port de communication  :
// PC : 1 COM1, 2 COM2
// LT : 0 liaison 0 V25, 1 liaison 1 V25, 2 UART 8250 No1, 3 UART 8250 No2     3
//      4 Liaison 0 SC2692, 5 Liaison1 SC2692
// FEC et HC01: 1 COM1
#define RDEBUG_COM 1

// pour FEC et HC01 FESTO on ne peut utiliser q'une vitesse de 9600 bauds,
// sans parit, 1 bit de stop

#if defined(FEC) || defined(HC01)
#define RDEBUG_BAUDRATE 9600l           // la vitesse en bauds
#define RDEBUG_PARITY 'N'               // 'E'ven (paire), 'O'dd (impaire), ou 'N'o (sans)
#define RDEBUG_STOPBIT 1                // 1 ou 2
#else
#define RDEBUG_BAUDRATE 115200l         // la vitesse en bauds
#define RDEBUG_PARITY 'O'               // 'E'ven (paire), 'O'dd (impaire), ou 'N'o (sans)
#define RDEBUG_STOPBIT 1		// 1 ou 2
#endif

// pour le HC01 FESTO

#ifdef HC01
// le type des 8 E/S de la CPU : E (bit  0) ou S (bit  1)
#define HC01_IO_MASK 0xf0 // ici 0  3 en entre, 4  7 en sortie ( modifier suivant besoins)

// le numro de la premire carte d'entre TOR
#define HC01_FIRSTI 1
// le nombre de carte(s) d'entre TOR
#define HC01_NI 1
// le numro de la premire carte de sortie TOR
#define HC01_FIRSTO 2
// le nombre de carte(s) de sorties TOR
#define HC01_NO 1


#endif
