#ifndef PLC_LIB
#define PLC_LIB

// This PLC_LIB.h does not run on MICROSOFT C compilers ! Use the
// PLC_LIB.h from the MICROSOFT directory. In this case you also have to
// use the PLC_LIB.lib located in the same directory.

/****************************************************************************
*
* (C) 1997-99 by Beck Computer-Loesungen GmbH
*
*  Beck Computer-Loesungen GmbH
*  Garbenheimer Str. 30-38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
*
* ATTENTION : This library will only work with BC01-Firmware V1.10 and above
*
* ---------------------------------------------------------------------------
* Module        :    PLC.C
* Function      :    BC0X/FCX0/HC0X interface standard functions
* Author        :    vb/tw/dg/ch
* Date          :    12.02.99
* Version       :    1.15
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author   Changes
*  0.01   11.02.97  vb      first version
*  0.02   20.02.97  vb      run-stop-switch,version,platform
*  0.03   21.02.97  vb      watchdog-mode, error A/B-direction
*                           all-disable(adjust,fast_counter,A/B-detection)
*  0.04   26.02.97  vb      interrupt/counter input functions
*                           (enable,disable,getvect,setvect)
*                           a/b incremental input
*                           a/b-init,a/b-deinit,interrupt-deinit,
*                           fast_counter-deinit, a/b-reset,
*                           fast_counter-reset
*  0.05   28.02.97  vb      fast_count-on,fast_count-off
*  0.06   18.04.97  dg      renamed to BC0X.C
*                                                       remote functions added
*                                                       geninterrupt() replaced bei int86/int86x
*  0.07   07.05.97  dg      timer services added
*  0.08   21.05.97  dg      static defines added
*  1.10   12.06.97  tw/dg   serial number added and version to 1.10
*                           include <string.h> added
*  1.11   01.02.99  ch      added the function Ansi_CrsrXY
*  1.12   03.02.99  ch      added the function Ansi_Color
*                           and some Ansi-Command Constants
*  1.13   04.02.99  ch      added the function isPLC
*  1.14   09.02.99  ch      added the function PLC_IO_SetMask
*  1.15   12.02.99  ch      changed function PLC_Flags_Init
*  1.16   18.02.99  ch      changed function Watchdog_GetMode, now it runs
*  1.17   19.02.99  ch      Made Image variables global
*  1.18   19.02.99  ch      removed unnecessary functions FastCounter_Enable
*                           and FastCounter_Disable
*  1.19   23.02.99  ap      bug fix in FastCounter_Info and IntrInputs_Info
*                           some function names renamed
*
****************************************************************************/

/* number of digital inputs*/
#define MAX_INPBITS 12
/* number of digital inputs bytes*/
#define MAX_INPBYTES 2
/* number of digital outputs*/
#define MAX_OUTBITS 8
/* number of digital output bytes*/
#define MAX_OUTBYTES 1
/* number of remote stations*/
#define MAX_REMOTE 1
/* number of remanent flags words (maximum = 1024)*/
#define MAX_FLAGS 128
/* max. number of areas in hc0x_rentop_type*/
#define MAX_RENT_ENTRIES 1
/* max. number of fast counters (hardware counter)*/
#define MAX_COUNTER 2
/* max. number of timers (0..9)*/
/* timer 0 is always used by for cycle time control*/
#define MAX_TIMER 10

/* defines*/
#define UCHAR unsigned char
#define UINT  unsigned int
#define BOOL  int
#define BYTE  unsigned char
#define WORD  unsigned int
#define DWORD unsigned long
#define FALSE 0
#define TRUE  1

/* communication*/

#define PLC_DEV_CON 0
#define PLC_DEV_EXT 1
#define PLC_DEV_COM 2

#define PLC_COM_EXT 0
#define PLC_COM_COM 1

/* define all local variables as static, so that they can be called*/
/* from an timer or counter interrupt procedure*/
#define PLC_STATIC static
/* define local variables not as static to save memory*/
/*#define PLC_STATIC*/

/* byte-array for byte to bit conversion*/
/*typedef int Byte_Type[8];*/

/* counter configuration*/
typedef struct
{
	BOOL Enable;
	WORD Max;
	WORD Mode;              /* 0=single / 1=continous*/
} Cfg_Counter_Type;

/* timer configuration*/
typedef struct
{
	BOOL Enable;
	int Handle;
	WORD Prescale;
} Cfg_Timer_Type;

/* process image configuration*/
typedef struct
{
	/* fast counter configuration*/
	Cfg_Counter_Type Counter[MAX_COUNTER];
	/* timer configuration*/
	Cfg_Timer_Type Timer[MAX_TIMER];
	/* cycles timer*/
	Cfg_Timer_Type Cycle;
	/* convert input-byte to input-bits and*/
	/* convert output-bits to output-byte*/
	/*BOOL BitArrayEnable;*/
	/* a/b incremental counter enable*/
	BOOL AB_Enable;
	/* adjustment trimmer enable*/
	BOOL TrimmerEnable;
	/* enable watchdog function*/
	BOOL WatchdogEnable;
	/* active remote stations and status*/
	int Remote;
	int RemoteStat;
	/* define cycle time in units of 55 ms*/
	int CycleTime;
} PLC_Cfg_Type;

typedef struct
{
	BYTE E_Byte[MAX_INPBYTES];
	BYTE E_Bit[MAX_INPBITS];
	int RunStop;
} E_Remote_Type;

typedef struct
{
	BYTE A_Byte[MAX_OUTBYTES];
	BYTE A_Bit[MAX_OUTBITS];
} A_Remote_Type;

typedef struct
{
	BYTE E_Byte[MAX_INPBYTES];
	BYTE E_Bit[MAX_INPBITS];
	int RunStop;
	WORD Count[2];
	DWORD Timer[MAX_TIMER];
	BYTE Trimmer;
	E_Remote_Type Remote[MAX_REMOTE];
} E_Type;

typedef struct
{
	BYTE A_Byte[MAX_OUTBYTES];
	BYTE A_Bit[MAX_OUTBITS];
	BYTE Led;
	A_Remote_Type Remote[MAX_REMOTE];
} A_Type;

/* retentive flags*/
typedef union
{
	BYTE M_Byte[MAX_FLAGS*2];               /* byte access*/
	WORD M_Word[MAX_FLAGS];                 /* word access*/
} M_Type;

/* structure for retentive operators/flags*/
typedef struct
{
	unsigned int Entries;           /* number of entries in remop_entry*/
	unsigned int Segment;           /* common segment address*/
	struct PLC_RentOp_Entry
	{
		unsigned int Offs;      /* offset adress*/
		unsigned int Size;      /* number of bytes (must be <= maxsize)*/
		unsigned int MaxSize;   /* maximal number of bytes*/
		unsigned int ElemSize;  /* number ob bytes per data-element*/
		unsigned int Distance;  /* distance to next data element*/
	} x[MAX_RENT_ENTRIES];
} PLC_RentOp_Type;

typedef BYTE Timer_Type[10];

extern E_Type E;                     /* input image (structure)*/
extern A_Type A;                     /* output image (structure)*/
extern M_Type M;                     /* retentive flags (union)*/
extern PLC_Cfg_Type PLC_Cfg;         /* PLC configuration (structure)*/
extern Timer_Type Timer_Buffer[MAX_TIMER];

// Ansi Steuercodes
extern char Ansi_ClrEol[];
extern char Ansi_ClrScr[];
extern char Ansi_CrsrHome[];

/* led states*/
#define LED_OFF 0
#define LED_GREEN 1
#define LED_RED 2
#define LED_ORANGE 3
#define LED_BLINK 4

/****************************************************************************
*
* Start of PLC/BC02 low-level BIOS and service-interrupt functions
*
*****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read hc0x/bc0x version information
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : version_data_ligth_bios:int *  (out hexadecimal)
*                 version_bc0x_firmware: int *    (out hexadecimal)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  20.02.97   vb     first
****************************************************************************/

void PLC_GetVersion(int *VersBios,int *VersPLC);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Hardware platform detection
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : platform : char *
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 20.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  20.02.97   vb     first version
****************************************************************************/

void PLC_GetPlatform(char *Platf);

/****************************************************************************
*
* (C) 1999 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : tests, if hardware is a PLC
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : int: 0 - no PLC  1 - is PLC
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : ch
* Last Changes  : 04.02.99
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  04.02.99   ch     first version
****************************************************************************/

int isPLC(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Get Serial number of PLC
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : Serial : char * : if not avail or not programmed Serial is
*                                                                       "000000"
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : tw
* Last Changes  : 10.06.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  10.06.97   vb     first version
****************************************************************************/

void PLC_GetSerial(char *Serial);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : user watchdog on
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   11.02.97  vb     first
****************************************************************************/

void PLC_Watchdog_SetUser(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : user watchdog refresh
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   11.02.97  vb     first
****************************************************************************/

void PLC_Watchdog_Refresh(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : switch back to BIOS watchdog
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   11.02.97  vb     first
****************************************************************************/

void PLC_Watchdog_SetBios(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read watchdog mode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : watchdog mode:int   (2|3)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   21.02.97  vb     first
****************************************************************************/

int PLC_Watchdog_GetMode(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set LED
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : number: int  (0..7)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 21.02.97
* Version       : 1.01
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*   1.00  11.02.97  vb     first
*   1.01  21.02.97  vb     set_LED
****************************************************************************/

void PLC_Led_Write(int value);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read LED status
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : -/-
* Return        : number: char
* Header-File   :  PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 21.02.97
* Version       : 1.01
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*   1.00  11.02.97  vb     first
*   1.01  21.02.97  vb     read_LED_status
****************************************************************************/

int PLC_Led_Read(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read run/stop switch
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : switch-position:int      (0|1)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  :  20.02.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  20.02.97   vb     first
****************************************************************************/

int PLC_RunStop_Read(void);

/****************************************************************************
*
* (C) 1999 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : sets HC0x I/O mask
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : buffer        : BYTE *
*             if one of the 8 bits =1: Output channel,   =0: Input channel
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : ch
* Last Changes  : 09.02.99
* Version       : 1.01
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  08.02.99   ch     first
*  1.01  09.02.99   ch     description added
****************************************************************************/

void PLC_IO_SetMask(void *buffer);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read digital input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : read-category:int(0-Byte,1-Word Hi-Byte=0, 2-Word Hi-Byte=1),
*                 destination-buffer:unsigned char pointer
*                 read-bytes-number:int (= length destination-buffer)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.01
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void PLC_Inputs_Read(void *buffer, int size);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Write to out
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : write-category: int ( 0-Byte,1-Word ),
*                                 source-buffer: unsigned char pointer ,
*                                 write-bytes-number:int (= length source-buffer)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void PLC_Outputs_Write(void *buffer, int size);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : get number of fast counters
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : -/-
* Return        : number:int     (2)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*   1.00  11.02.97  vb      first version
****************************************************************************/

int PLC_FastCounter_Info(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : init fast counter
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : couunter: int            (counter number),
*                 mode: int                (0-single|1-continious),
*                 max : unsigned int       (max. counter value)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb      first
****************************************************************************/

void PLC_FastCounter_Init(int n, int mode, WORD max);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : deinit fast counter
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : counter number: int     (0|1),
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb      first
****************************************************************************/

void PLC_FastCounter_Deinit(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : start fast counter
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : counter number:int (0|1)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.07
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97  vb      first version
****************************************************************************/

void PLC_FastCounter_Start(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : stop fast counter
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : counter number: int (0|1)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb      first version
****************************************************************************/

void PLC_FastCounter_Stop(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read fast counter value
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : counter number:int    (0|1)
* Return        : counter position: unsigned int
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb      first
****************************************************************************/

WORD PLC_FastCounter_Read(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : reset fast counter to zero
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : counter number:int (0|1)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97  vb      first
****************************************************************************/

void PLC_FastCounter_SetZero(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : trimmer on
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void PLC_Trimmer_Enable(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : trimmer off
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : BC0X.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void PLC_Trimmer_Disable(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read trimmer value
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : adjust position: int
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

int PLC_Trimmer_Read(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : initalize A/B incremental counter
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : zerovalue: int
* Return        :    -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   26.02.97  vb      first
****************************************************************************/

void PLC_ABcount_Init(int ZeroValue);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : deinitalise A/B incremental counter
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   26.02.97  vb      first
****************************************************************************/

void PLC_ABcount_Deinit(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set A/B incremental counter to zerovalue
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   26.02.97  vb      first version
****************************************************************************/

void PLC_ABcount_Reset(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read A/B incremental counter value
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : error: int *     (0 no error, 1 overflow , -1 underflow)
* Return        : counter-position: int
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb      first
****************************************************************************/

int PLC_ABcount_Read(int *error);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read A/B incremental counter direction
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : -/-
* Return        : direction-position:int    (0|1 example 0-A 1-B)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97  vb      first version
****************************************************************************/

int PLC_ABcount_ReadDirection(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set A/B reference
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : number :int   (0-7),
				  bit0: 0=no reference setting / 1=reference setting
				  bit1: 0=set ref. only one time / 1=allways set ref.
				  bit2: 0=set ref. on direction=0 / 1=set ref. on direction=1
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  09.06.97   dg     first
****************************************************************************/

void PLC_ABcount_SetReferenceMode(int ReferenceMode);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : check if remote driver REO.EXE is installed
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : int   0 = host
						1 = remote
						-1 = stand-alone (not initialised)
						-2 = driver not installed
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  21.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  18.04.97   dg     first version
****************************************************************************/

int PLC_Remote_Installed(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : initialise remote driver and set to master mode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : remote_count: int
* Return        : int (1=no error / 0=error - slaves not found)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  18.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  18.04.97   dg     first version
****************************************************************************/

int PLC_Remote_Init(int remote_count);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read run/stop switch, local and remote
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : remote:int (0=local, 0xFF0n=remote, n=0..2)
* Return        : switch-position:int      (0|1)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  18.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  18.04.97   dg     first
****************************************************************************/

int PLC_RunStop_ReadRemote(int remote);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read local and remote inputs
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : read-category:int(0-Byte,1-Word Hi-Byte=0, 2-Word Hi-Byte=1),
*                                          destination-buffer:unsigned char pointer
*                 read-bytes-number:int (= length destination-buffer)
*                                               remote:int (0=local, 0xFF0n=remote, n=0..2)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 18.04.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  19.04.97   dg     first version
****************************************************************************/

void PLC_Inputs_ReadRemote(void *buffer, int size, int remote);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : write to digital output (local and remote)
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : write-category: int ( 0-Byte,1-Word ),
*                                 source-buffer: unsigned char pointer ,
*                                 write-bytes-number:int (= length source-buffer)
*                                 remote:int (0=local, 1..3=remote)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  18.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  18.04.97   dg     first
****************************************************************************/

void PLC_Outputs_WriteRemote(void *buffer, int size, int remote);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read number of interrupt inputs
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : number:int      (2)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

int PLC_IntrInputs_Info(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : configure input E1.n as interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number: int    (0|1)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first version
****************************************************************************/

void PLC_IntrInputs_Enable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : configure E1.n as standard digital input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number: int    (0|1)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first
****************************************************************************/

void PLC_IntrInputs_Disable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read interrupt vector for interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number: int         (0|1)
* Return        : pointer :void interrupt  (oldhandler)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void interrupt (*PLC_IntrInputs_GetVect(int n))(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set interrupt service routine for interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number:int   (0|1),
*                 pointer :void interrupt      (handler)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void PLC_IntrInputs_SetVect(int n, void interrupt (*handler)());

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : enable interrupt for interrupt input E1.n
* Prototype     : (as listed in header-file)
* Public/Local  : public (public means prototype is in header-file)
* Parameters    : input number:int (0|1)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 11.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void PLC_IntrInputs_IntEnable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : disable interrupt for interrupt input E1.n
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : input number: int (0|1)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  11.02.97   vb     first
****************************************************************************/

void PLC_IntrInputs_IntDisable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : trimmer off, fast counter off, A/B incremental counter off
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 21.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  21.02.97   vb     first version
****************************************************************************/

void PLC_DisableAll(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : enable interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : entry-number   (0|1)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : vb
* Last Changes  : 26.02.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first version
****************************************************************************/

void PLC_IntrCount_IntEnable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : disable interrupt input
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : entry-number   (0|1)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first
****************************************************************************/

void PLC_IntrCount_IntDisable(int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : get pointer to service routine of interrupt input n
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : entry-number: int (0|1)
* Return        : pointer :void interrupt   (oldhandler)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first
****************************************************************************/

void interrupt(*PLC_IntrCount_GetVect(int n))(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set service routine for interrupt input n
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : entry-number :int   (0|1),
*                 pointer : void interrupt      (handler)
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  vb
* Last Changes  : (date)
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  26.02.97   vb     first
****************************************************************************/

void PLC_IntrCount_SetVect(int n,void interrupt (*handler)());

/**************************************************************************/
/**/
/*  Timer/Counter-Services  */
/**/
/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : check if timer/counter avset service routine for interrupt input n
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : int: 0=not available, 1=available
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 30.04.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  30.04.97   dg     first version
****************************************************************************/

int PLC_Timer_Installed(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : enable timer service
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : TimerType *Buffer: pointer to timer buffer
*               : int n: number of timer
* Return        : int: 0=no error, 1=error
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL PLC_Timer_Enable(Timer_Type *Buffer, int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : disable timer service
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : TimerType *Buffer: pointer to timer buffer
*               : int n: number of timer
* Return        : int: 0=no error, 1=error
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

void PLC_Timer_Disable(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : insert a new 32 bit timer
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int ContMode
*               : int IncMode
*               : WORD Prescale
* Return        : int: handle (timer number)
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

int PLC_Timer_Insert(int ContMode, int IncMode, WORD Prescale);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set timer increment mode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
*               : int IncMode: count mode
* Return        : BOOL: 0 = error, 1 = ok
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

int PLC_Timer_SetIncr(int Handle, int IncMode);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : get timer periode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: 0 = error, >0 = prescale value
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

WORD PLC_Timer_GetPrescale(int Handle);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set timer periode
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
*               : WORD Prescale: prescale value
* Return        : BOOL: 0 = error, 1 = ok
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL PLC_Timer_SetPrescale(int Handle, WORD Prescale);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : start timer
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: 0 = error, 1 = ok
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL PLC_Timer_Start(int Handle);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : stop timer
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: 0 = error, 1 = ok
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL PLC_Timer_Stop(int Handle);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read timer value
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: timer value, 0xFFFF = error
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

DWORD PLC_Timer_Read(int Handle);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : read timer value
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int Handle: timer number
* Return        : BOOL: timer value, 0xFFFF = error
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

BOOL PLC_Timer_Write(int Handle, DWORD Value);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set timer interrupt routine
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int CntrMode:
*               : WORD Prescale:
*               : void interrupt (*handler)()): pointer to interrupt routine
* Return        : int:
* Header-File   : HC0X.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 07.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  07.05.97   dg     first version
****************************************************************************/

int PLC_TimerIntr_SetVect(int CntrMode,WORD Prescale,
						   void interrupt (*handler)());

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : get BIOS timer value, 55ms = 18.2 hertz
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : long:
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

long PLC_BiosTimer_Get(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : wait until BIOS timer reaches the value biostime+wait
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : long: BiosTime
*                                 int: Wait
* Return        : int:
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

int PLC_BiosTimer_Wait(long biostime, int wait);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : wait for n BIOS-timer ticks
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Ticks
* Return        : -/-
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 27.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  27.05.97   dg     first version
****************************************************************************/

void PLC_BiosTimer_Delay(int Ticks);

/****************************************************************************
*
* Start of high-level hc0x/bc0x functions
*
*****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : convert byte-array to bit-array
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : bits: int  (bit array)
* Return        : bytes: typebyte (byte array)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  19.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  19.04.97   dg     first
****************************************************************************/

void PLC_InputsToBit(void *InpBytes, void *InpBits, int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : convert bit-array to byte-array
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : bytes: typebyte (byte array)
* Return        : bits: int (bit array)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  dg
* Last Changes  :  19.04.97
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  19.04.97   dg     first version
****************************************************************************/

void PLC_OutputsToByte(void *OutBits, void *OutBytes, int n);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : define and read retentive flags from flash memory
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : size: int (number of flags bytes)
*               : m: M_type  (retentive flags)
* Return        : HC0X: int Segment-Adress of retentive flag-area
*                       (Call: adr=PLC_Flags_Init(NULL,0);)
*                 ELSE: int (0=error, 1=ok)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        :  dg/ch
* Last Changes  :  12.02.99
* Version       :  1.02
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  29.04.97   dg     first version
*  1.01  07.05.97   dg     changed pointer type to void
*                          changed order of parameters
*  1.02  12.02.99   ch     made compatible with HC0X platforms
*                          size=0 now not allowed
****************************************************************************/

int PLC_Flags_Init(void *M, int size);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : write retentive flags to flash memory
*                                 uses values from PLC_Flags_Read
* Prototype     : (as listed in header-file)
* Public/Local  : public  (public means prototype is in header-file)
* Parameters    : -/-
* Return        : int (0=error, 1=ok)
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg
* Last Changes  : 29.04.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  27.04.97   dg     first version
****************************************************************************/

int PLC_Flags_Write(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : reset PLC_Cfg
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 09.06.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  09.06.97   dg     first version
****************************************************************************/

void PLC_Image_CfgClr(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Initialize process image
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Image_Init(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Deinitialize process image
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Image_Deinit(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Read process image
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Image_Read(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Put Image bits into bit-array
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Image_InputToBits(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Write process image
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Image_Write(void);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Put output bits form bitarray into byte
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : -
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Image_OutputToByte(void);

/****************************************************************************
*
* (C) 1999 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set cursor to position x,y with ANSI codes
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int:            BYTE: x
*                                 BYTE: y
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : ch
* Last Changes  : 01.02.99
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  01.02.99   ch     first version
****************************************************************************/

void Ansi_CrsrXY(BYTE x, BYTE y);

/****************************************************************************
*
* (C) 1999 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : sends an ansi color command
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int:            INT : a 0..15 foreground
*                                 INT : b 0..7  background
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : ch
* Last Changes  : 03.02.99
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  03.02.99   ch     first version
****************************************************************************/

void Ansi_Color(int a,int b);


/**********************************************************************/
/**/
/*  PLC/BC0x Console I/O*/
/**/
/*********************************************************************/

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Set baud rate for com port
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Port                     Portnr
*                                 int: Baud                     Baudrate
*                                 int: Parity           Parity
*                                 int: Datenbits        Databits
*                                 int: Stopbits         Stopbits
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

int PLC_Com_SetBaud(int Port,int Baud,int Parity,int Datenbits,int Stopbits);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Initialize com port
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: port
* Return        : BOOL:
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

BOOL PLC_Com_Init(int Port);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Get Char from Console
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
* Return        : int:
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

int PLC_GetChar(int Channel);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Put char to console
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
*                                 int: c
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_PutChar(int Channel, int c);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Put string to  console
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
*                                 char: *s string
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_PutStr(int Channel, char *s);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : set cursor to position x,y with ANSI codes
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
*                                 BYTE: x
*                                 BYTE: y
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Ansi_CrsrXY(int Channel, BYTE x, BYTE y);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Set cursor in upper left corner of screen with ANSI-codes
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Ansi_CrsrHome(int Channel);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Clear screen with ANSI-codes
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Ansi_ClrScr(int Channel);

/****************************************************************************
*
* (C) 1997 by Beck Computer-Loesungen GmbH
*
* ---------------------------------------------------------------------------
* Function      : Clear to end of Line with ANSI-codes
* Prototype     : (as listed in header-file)
* Public/Local  : local  (public means prototype is in header-file)
* Parameters    : int: Channel
* Return        : -
* Header-File   : PLC.H
* ---------------------------------------------------------------------------
* Author        : dg/tw
* Last Changes  : 25.05.97
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00  25.05.97   dg     first version
****************************************************************************/

void PLC_Ansi_ClrEol(int Channel);

/****************************************************************************
* END OF PLC.H
****************************************************************************/
#endif
