// Systme de mise au point  distance pour les applications
// gnres par le post-processeur C d'AUTOMGEN V6
// pour PC, automates LT LEROY et FEC FESTO
// 19/03/1997 : version compatible avec les automates LT de LEROY AUTOMATISME
// 21/09/1998 : version compatible avec l'automate FEC de FESTO
// (C) 1998 IRAI

#include "c:\automv6\c\config.h"

#if defined(FEC) || defined(HC01)
#include "string.h"
#endif


#ifdef LT
#include"\lt_prog\include\lt100usr.h"
#include"\lt_prog\include\time2.h"
#include"\lt_prog\include\periodi.h"
#include"\lt_prog\include\29f010.h"
#include "c:\lt_prog\include\cdg.h"

void SetUCLed(unsigned);
void ResetUCLed(unsigned);

#endif

#include "stdlib.h"
#include "stdio.h"
#include "dos.h"
#if defined(__BORLANDC__) || defined(__TURBOC__)
#include "conio.h"
#include "mem.h"
#include "alloc.h"
#else
#define peek(s,o) (*(unsigned far *)(_MK_FP(s,o)))
#include "memory.h"
#include "malloc.h"
#endif
#include "process.h"
#include "io.h"
#include "math.h"


int comint_config(  unsigned comport,
					unsigned long speed,
					unsigned parity,
					unsigned databit,
					unsigned stopbit);

void comint_stopcom(void);
void comint_putcom(unsigned char c);
int comint_getcom(void);
int comint_ischar(void);
int comint_ischarout(void);
void comint_setrts(unsigned state);

#ifdef LT
TTime lt_time;
#define TIMOUT 1000
#else
#define TIMOUT 10
#endif

unsigned lasttimetimout;

// Traitement du timout
void inittimout(void)
{
#ifdef LT
lasttimetimout=TimeState(&lt_time);
#else
lasttimetimout=peek(0x40,0x6c);
#endif
}

int istimout(void)
{
#ifdef LT
return (TimeState(&lt_time)-lasttimetimout>=TIMOUT)?1:0;
#else
return (peek(0x40,0x6c)-lasttimetimout>=TIMOUT)?1:0;
#endif
}

// Emission d'une trame
void rdebug_sendtrame(unsigned char *data,unsigned len)
{
unsigned char crc;
unsigned count;
crc='Z'+(unsigned char)(len&0xff)+(unsigned char)(len>>8);
comint_putcom('Z');
comint_putcom((unsigned char)(len&0xff));
comint_putcom((unsigned char)(len>>8));

for(count=0;count<len;count++)
	{
	comint_putcom(data[count]);
	crc+=data[count];
	}
comint_putcom((unsigned char )(~crc));
}

// Buffer de rception
unsigned ltramein;
unsigned char tramein[1200];

// Pour la gestion du calcul du temps de cycle
unsigned lasttime;
unsigned cycleps;

#if !defined(LTLOADER) && !defined(FECLOADER)
// Conversion format flottant IEEE vers format AUTOMGEN
void ieeetoautomgen(float real[],unsigned len)
{
unsigned count;
for(count=0;count<len;count++)
	{
	int iExp;
	long iMant;
	unsigned char *p;
	p=(unsigned char *)&real[count];
	if(p[0]!=0||p[1]!=0||p[2]!=0||p[3]!=0)
		{
		iExp=(((p[3]&0x7f)<<1)|((p[2]&0x80)>>7))-127;
		iMant=0x800000l|(unsigned long)p[0]|((unsigned long)p[1]<<8)|((unsigned long)(p[2]&0x7f)<<16);
		while(iMant>=16384)
			{
			iMant>>=1;
			iExp--;
			}
		if(p[3]&0x80) iMant=-iMant;
		iExp-=3;
		memcpy(&p[2],&iExp,2);
		memcpy(&p[0],&iMant,2);
		}
	}
}

// Conversion format flottant AUTOMGEN vers format IEEE
void automgentoieee(float real[],unsigned len)
{
unsigned count;
unsigned long *l;
for(count=0;count<len;count++)
	{
	int sign=0;
	double dExp;
	double dMant;
	l=(unsigned long *)&real[count];
	dMant=(int)((*l)&0xffff);
	dExp=(int)((unsigned long)(*l)>>16);
	if(dMant<0)
		{
		dMant=-dMant;
		sign=1;
		}
	real[count]=(float)(pow(2,dExp)*dMant);
	if(sign)
		{
		real[count]=-real[count];
		}
	}
}

#endif


// Traitement des trames
void rdebug_processtrame(void)
{
extern int run;
extern int init;
extern int step;
extern unsigned char in[];
extern unsigned char out[];
extern unsigned char bit[];
extern unsigned word[];
extern unsigned long dword[];
extern float real[];
// Pour le tlchargement de programme

static unsigned char progname[13];
static unsigned long proglen;

//definit un nom de programme : toujours le mme pour FEC de FESTO
#if defined(FEC) || defined(HC01)
static unsigned char *nom="AUTOM.EXE";
#endif

#ifdef LT
static unsigned char *progmem=NULL;
#else
static FILE *fprog;
#if defined(__BORLANDC__) || defined(__TURBOC__)
static unsigned char far *progmem;
#else
static unsigned char huge *progmem;
#endif
#endif
if(ltramein>0)
	{
	switch(tramein[0]) // Code de fonction
		{
		case 0 : // Test de connexion
			{
			if(ltramein==1)
				{
				rdebug_sendtrame("\x00",1); // Ok
				}
			else
				{
				rdebug_sendtrame("\xFF",1); // NO
				}
			} break;
		case 1 : // Changement de mode ou lecture de mode RUN/STOP
			{
			if(ltramein!=2)
				{
				rdebug_sendtrame("\xFF",1); // NO
				}
			else
				{
				switch(tramein[1]) // Le mode
					{
					case 0 : // stop
						{
						if(run)
							{
							run=0;
							rdebug_sendtrame("\x00",1); // Ok
							}
						else
							{
							rdebug_sendtrame("\xFE",1); // refus
							}
						} break;
					case 1 : // run
						{
						if(!run)
							{
							run=1;
							rdebug_sendtrame("\x00",1); // Ok
							}
						else
							{
							rdebug_sendtrame("\xFE",1); // refus
							}
						} break;
					case 2 : // step
						{
						if(!run)
							{
							step=1;
							rdebug_sendtrame("\x00",1); // Ok
							}
						else
							{
							rdebug_sendtrame("\xFE",1); // refus
							}
						} break;
					case 3 : // init
						{
						init=1;
						rdebug_sendtrame("\x00",1); // Ok
						} break;
					case 0x80 : // lecture RUN/STOP
						{
						rdebug_sendtrame(run?"\x00\x01":"\x00\x00",2); // Ok
						} break;
					default :
						{
						rdebug_sendtrame("\xFF",1); // NO
						}
					}
				}
			} break;
		case 2 : // Lecture de l'tat d'une ou plusieurs variables
			{
			#if (defined(LTLOADER) || defined(FECLOADER)) && !defined(TEST)
			rdebug_sendtrame("\xFF",1); // NO
			#else
			unsigned char data[1025];
			unsigned first,len;
			unsigned count;
			if(ltramein!=6)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			first=tramein[2]+(tramein[3]<<8);
			len=tramein[4]+(tramein[5]<<8);
			switch(tramein[1]) // Le type
				{
				case 0 : // Entres
					{
					if(len+first>NINPUT||(len+7)/8>1024)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					memset(data,0,1025);
					for(count=0;count<len;count++)
						{
						if(in[count+first]) data[1+count/8]|=1<<(count&7);
						}
					rdebug_sendtrame(data,1+(len+7)/8);
					} break;
				case 1 : // Sorties
					{
					if(len+first>NOUTPUT||(len+7)/8>1024)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					memset(data,0,1025);
					for(count=0;count<len;count++)
						{
						if(out[count+first]) data[1+count/8]|=1<<(count&7);
						}
					rdebug_sendtrame(data,1+(len+7)/8);
					} break;
				case 2 : // Bits
					{
					if(len+first>NBIT||(len+7)/8>1024)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					memset(data,0,1025);
					for(count=0;count<len;count++)
						{
						if(bit[count+first]) data[1+count/8]|=1<<(count&7);
						}
					rdebug_sendtrame(data,1+(len+7)/8);
					} break;
				case 3 : // Mots
					{
					if(len+first>NWORD||len*sizeof(unsigned long)>1024)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					data[0]=0;
					memcpy(&data[1],&word[first],len*sizeof(unsigned));
					rdebug_sendtrame(data,1+len*sizeof(unsigned));
					} break;
				case 4 : // Longs
					{
					if(len+first>NDWORD||len*sizeof(unsigned long)>1024)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					data[0]=0;
					memcpy(&data[1],&dword[first],len*sizeof(unsigned long));
					rdebug_sendtrame(data,1+len*sizeof(unsigned long));
					} break;
				case 5 : // Flottants
					{
					if(len+first>NFLOAT||len*sizeof(float)>1024)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					data[0]=0;
					memcpy(&data[1],&real[first],len*sizeof(float));
					// Conversion format IEEE -> format AUTOMGEN
					ieeetoautomgen((float *)&data[1],len);
					rdebug_sendtrame(data,1+len*sizeof(float));
					} break;
				default :
					{
					rdebug_sendtrame("\xFF",1); // NO
					}
				}
			#endif
			} break;
		case 3 : // Ecriture de l'tat d'une variable
			{
			#if (defined(LTLOADER) || defined(FECLOADER)) && !defined(TEST)
			rdebug_sendtrame("\xFF",1); // NO
			#else
			unsigned num;
			num=tramein[2]+(tramein[3]<<8);
			switch(tramein[1]) // Le type
				{
				case 0 : // Entres
					{
					if(ltramein!=5||num>=NINPUT)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					in[num]=tramein[4]?1:0;
					rdebug_sendtrame("\x00",1); // Ok
					} break;
				case 1 : // Sorties
					{
					if(ltramein!=5||num>=NOUTPUT)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					out[num]=tramein[4]?1:0;
					rdebug_sendtrame("\x00",1); // Ok
					} break;
				case 2 : // Bits
					{
					if(ltramein!=5||num>=NBIT)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					bit[num]=tramein[4]?1:0;
					rdebug_sendtrame("\x00",1); // Ok
					} break;
				case 3 : // Mots
					{
					if(ltramein!=6||num>=NWORD)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					memcpy(&word[num],&tramein[4],2);
					rdebug_sendtrame("\x00",1); // Ok
					} break;
				case 4 : // Longs
					{
					if(ltramein!=8||num>=NDWORD)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					memcpy(&dword[num],&tramein[4],4);
					rdebug_sendtrame("\x00",1); // Ok
					} break;
				case 5 : // Flottants
					{
					if(ltramein!=8||num>=NDWORD)
						{
						rdebug_sendtrame("\xFF",1); // NO
						break;
						}
					automgentoieee((float *)&tramein[4],1);
					memcpy(&real[num],&tramein[4],4);
					rdebug_sendtrame("\x00",1); // Ok
					} break;
				default :
					{
					rdebug_sendtrame("\xFF",1); // NO
					}
				}
			#endif
			} break;
		case 4 : // Dbut de tlchargement d'un programme
			{
                        #if defined(FEC) || defined(HC01)
			//Si on detruit un fichier,alors rorganiser la mmoire du FEC
			if((unlink(nom)==0))
			 {
				rdebug_sendtrame("\x80",1); // Ce qui suit peut tre long
				spawnlp(P_WAIT,"a:\chkffs.exe","chkffs.exe","/f", NULL);
			 }
			#endif
			if(ltramein<6||ltramein>17)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			memcpy(&proglen,&tramein[1],4);
			memcpy(&progname,&tramein[5],ltramein-5);
			progname[ltramein-5]=0;
			#ifdef LT
			#ifndef LTLOADER
			// Effacer le premier secteur
			rdebug_sendtrame("\xC0",1); // Patienter et recommencer l'opration
			EffaceFlash(2,1);
			comint_stopcom();
			// Rebooter le LT
			asm mov ax,1
			asm mov TempsChienDeGarde,ax
			while(1);
			// Rebooter le LT
			#else
			rdebug_sendtrame("\x80",1); // Patienter
			#endif
			// Dbut de tlchargement sur un automate LT
			// Allumer la led prg
			SetUCLed(16);
			// Allouer un bloc de mmoire temporaire de 16k
			progmem=malloc(0x4000);
			if(progmem==NULL)
				{
				rdebug_sendtrame("\xfe",1); // Erreur
				break;
				}
			memset(progmem,0xff,0x4000);
			// Initialiser la mmoire FLASH de C800:0000  CC00:FFFF
			rdebug_sendtrame("\x80",1); // Patienter
			EffaceFlash(2,2);
			EffaceFlash(4,3);
			#else
			if(fprog!=NULL) fclose(fprog);
			if(progmem!=NULL)
				{
				#if defined(__BORLANDC__) || defined(__TURBOC__)
				farfree(progmem);
				#else
				_hfree(progmem);
				#endif
				progmem=NULL;
				}
			#endif
			#ifdef LT
			if(proglen>(5lu*0x4000lu))
				{
				ResetUCLed(16);
				rdebug_sendtrame("\xFE",1); // erreur
				break;
				}
			#else
			fprog=fopen("RDEBUG.TMP","w+b");
			if(fprog==NULL)
				{
				rdebug_sendtrame("\xFE",1); // erreur
				break;
				}
			#if defined(__BORLANDC__) || defined(__TURBOC__)
			progmem=farmalloc(proglen);
			#else
			progmem=_halloc(proglen,1);
			#endif
			#endif
			rdebug_sendtrame("\x00",1); // OK
			} break;
		case 5 : // Tlchargement d'un bloc de programme
			{
			unsigned long pos,len;
			#ifndef LT
			if(fprog==NULL)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			#endif
			memcpy(&pos,&tramein[1],4);
			memcpy(&len,&tramein[5],4);
			if(pos+len>proglen)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			#ifdef LT
			if(progmem==NULL)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			memcpy(&progmem[pos&0x3fff],&tramein[9],len);
			// Transfert RAM->EPROM FLASH en fin de secteur ou en fin de programme
			if(((pos+len)&0x3fff)==0||pos+len==proglen)
				{
				rdebug_sendtrame("\x80",1); // Ce qui suit peut tre long
				if(pos<0x8000) // Deux premiers secteurs
					{
					/*
					if(EffaceFlash(2+(pos/0x4000),1)!=-1)
						{
						rdebug_sendtrame("\xF0",1); // erreur
						}
					*/
					if(EcritureFlashInf(0x8000+(0x4000*(pos/0x4000)),progmem,0x4000)!=-1)
						{
						rdebug_sendtrame("\xF1",1); // erreur
						}
					if(_fmemcmp(MK_FP(0xc800,(pos/0x4000)*0x4000),progmem,0x4000)!=0)
						{
						rdebug_sendtrame("\xF2",1); // erreur
						free(progmem);
						progmem=NULL;
						break;
						}
					}
				else
					{
					/*
					if(EffaceFlash(4+((pos-0x8000)/0x4000),1)!=-1)
						{
						rdebug_sendtrame("\xF3",1); // erreur
						}
					*/
					if(EcritureFlashSup(0x4000+(((pos-0x8000)/0x4000)*0x4000),progmem,0x4000)!=-1)
						{
						rdebug_sendtrame("\xF4",1); // erreur
						}
					if(_fmemcmp(MK_FP(0xd000,((pos/0x4000)*0x4000)-0x8000),progmem,0x4000)!=0)
						{
						rdebug_sendtrame("\xF5",1); // erreur
						free(progmem);
						progmem=NULL;
						break;
						}
					}
				memset(progmem,0xff,0x4000);
				}
			#else
			if(progmem==NULL)
				{
				fseek(fprog,pos,0);
				if(fwrite(&tramein[9],(unsigned)len,1,fprog)!=1)
					{
					rdebug_sendtrame("\xFD",1); // erreur
					break;
					}
				}
			else
				{
				_fmemcpy(&progmem[pos],&tramein[9],(unsigned)len);
				}
			#endif
			rdebug_sendtrame("\x00",1); // OK
			} break;
		case 6 : // Fin de tlchargement d'un programme
			{
			#ifndef LT
			if(fprog==NULL)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			#endif
			if(ltramein<6||ltramein>17)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			if(memcmp(&proglen,&tramein[1],4)!=0||memcmp(&progname,&tramein[5],ltramein-5)!=0)
				{
				rdebug_sendtrame("\xFE",1); // erreur
				break;
				}
			#ifdef LT
			if(progmem==NULL)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			// Eteindre la led prg
			ResetUCLed(16);
			free(progmem);
			progmem=NULL;
			rdebug_sendtrame("\x80",1); // OK
			#ifdef LTLOADER
			comint_stopcom();
			// Rebooter le LT
			asm mov ax,1
			asm mov TempsChienDeGarde,1
			while(1);
			#endif
			break;
			#else
			if(progmem!=NULL)
				{
				unsigned long count;
				for(count=0;count<proglen;count+=1024)
					{
					unsigned bloclen;
					bloclen=min(1024,proglen-count);
					_fmemcpy(tramein,&progmem[count],bloclen);
					if(fwrite(tramein,bloclen,1,fprog)!=1)
						{
						fclose(fprog);
						#if defined(__BORLANDC__) || defined(__TURBOC__)
						farfree(progmem);
						#else
						_hfree(progmem);
						#endif
						progmem=NULL;
						rdebug_sendtrame("\xFD",1); // erreur
						break;
						}
					}
				}
			fclose(fprog);
			fprog=NULL;
			#if defined(__BORLANDC__) || defined(__TURBOC__)
			farfree(progmem);
			#else
			_hfree(progmem);
			#endif
			progmem=NULL;
			unlink(progname);
                        #if !defined(FEC) && !defined(HC01)
			if(rename("RDEBUG.TMP",progname)!=0)
				{
				rdebug_sendtrame("\xFD",1); // erreur
				break;
				}
			#else
			//on definit pour FEC de FESTO un nom de programme ; toujours le mme
			if(rename("RDEBUG.TMP",nom)!=0)
				{
				rdebug_sendtrame("\xFD",1); // erreur
				break;
				}
			#endif
                        #if !defined(FEC) && !defined(HC01)
			printf("RDEBUG : chargement de %s\n",progname);
			#endif
			rdebug_sendtrame("\x00",1); // OK
			while(comint_ischarout());
			comint_stopcom();
                        #if defined(FEC) || defined(HC01)
			execl(nom,nom,NULL);
			#else
			execl(progname,progname,NULL);
			#endif

			#ifndef LT
			printf("RDEBUG : ERREUR : excution de %s impossible\n",progname);
			#endif
			// Si on arrive ici c'est que l'excution a choue
			if(comint_config(RDEBUG_COM,RDEBUG_BAUDRATE,RDEBUG_PARITY,8,RDEBUG_STOPBIT)!=0)
				{
				#ifndef LT
				printf("RDEBUG : ERREUR : impossible d'initiliser le port de communicaton : paramtres errons ou port non install\n");
				exit(1);
				#endif
				}
			#endif
			#ifndef LT
			rdebug_sendtrame( "\xFC",1); // erreur
			#endif
			} break;
		case 7 : // Dbut de vrification d'un programme
			{
			if(ltramein<6||ltramein>17)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			memcpy(&proglen,&tramein[1],4);
			memcpy(&progname,&tramein[5],ltramein-5);
			progname[ltramein-5]=0;

                        #if defined(FEC) || defined(HC01)
			strcpy(progname,nom);
			#endif
			#ifdef LT // Dbut de vrification sur un LT
			#else
			if(fprog!=NULL) fclose(fprog);
			if(progmem!=NULL)
				{
				#if defined(__BORLANDC__) || defined(__TURBOC__)
				farfree(progmem);
				#else
				_hfree(progmem);
				#endif
				progmem=NULL;
				}
			fprog=fopen(progname,"rb");
			if(fprog==NULL)
				{
				rdebug_sendtrame("\xFE",1); // erreur programme inexistant
				break;
				}
			if(filelength(fileno(fprog))!=proglen)
				{
				rdebug_sendtrame("\xFD",1); // erreur longueur diffrente
				break;
				}
			#endif
			rdebug_sendtrame("\x00",1); // OK
			} break;
		case 8 : // Vrification d'un bloc de programme
			{
			unsigned long pos,len;
			#ifdef LT
			unsigned offset,segment;
			#else
			if(fprog==NULL)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			#endif
			if(ltramein!=9)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			memcpy(&pos,&tramein[1],4);
			memcpy(&len,&tramein[5],4);
			if(pos+len>proglen)
				{
				rdebug_sendtrame("\xFF",1); // NO
				break;
				}
			#ifdef LT
			offset=(unsigned)pos;
			pos>>=16;
			segment=(unsigned)pos;
			segment*=0x1000;
			segment+=0xc800;
			_fmemcpy(&tramein[1],MK_FP(segment,offset),len);
			#else
			fseek(fprog,pos,0);
			if(fread(&tramein[1],(unsigned)len,1,fprog)!=1)
				{
				rdebug_sendtrame("\xFD",1); // erreur
				break;
				}
			#endif
			tramein[0]=0;
			rdebug_sendtrame(tramein,(unsigned)len+1); // OK
			} break;
		case 9 : // Fin de vrirication d'un programme
			{
			#ifndef LT
			if(fprog==NULL)
               	{
				rdebug_sendtrame("\xFF",1); // NO
                break;
                }
			#endif
			if(ltramein<6||ltramein>17)
				{
				rdebug_sendtrame("\xFF",1); // NO
                break;
                }
            #ifndef LT
			fclose(fprog);
			fprog=NULL;
			#if !defined(FEC) && !defined(HC01)
			if(memcmp(&proglen,&tramein[1],4)!=0||memcmp(&progname,&tramein[5],ltramein-5)!=0)
				{
				rdebug_sendtrame("\xFE",1); // erreur
				break;
				}
			#else
			if(memcmp(&proglen,&tramein[1],4)!=0)
				{
				rdebug_sendtrame("\xFE",1); // erreur
				break;
				}
			#endif
			#endif
			rdebug_sendtrame("\x00",1); // OK
			} break;
		case 10 : // Lecture du temps de cycle
			{
			if(ltramein!=1)
				{
				rdebug_sendtrame("\xFF",1); // NO
				}
			else
				{
				tramein[0]=0; // OK
				memcpy(&tramein[1],&cycleps,2);
				rdebug_sendtrame(tramein,3); // Ok
				}
            } break;
        default :
			{
			rdebug_sendtrame("\xFF",1); // NO
			}
		}
	}
}


// Initialisation
void rdebug_init(void)
{
#if defined(FEC) || defined(HC01)
asm mov dx,RDEBUG_COM
asm mov ah,04h
asm int 14h
#endif
if(comint_config(RDEBUG_COM,RDEBUG_BAUDRATE,RDEBUG_PARITY,8,RDEBUG_STOPBIT)!=0)
	{
        #if !defined(LT) && ! defined(FEC) && !defined(HC01)
	printf("RDEBUG : ERREUR : impossible d'initiliser le port de communicaton : paramtres errons ou port non install\n");
	#endif
	exit(1);
	}

#if !defined(LT) && !defined(FEC) && !defined(HC01)
printf("RDEBUG : port initialis COM%u,%lu,%c,%u\n",RDEBUG_COM,RDEBUG_BAUDRATE,RDEBUG_PARITY,RDEBUG_STOPBIT);
#endif
#ifdef LT
// Initialise un timer
InitChrono(&lt_time,&CompteurMilliseconde,0,0);
TimePreset(&lt_time,1);
TimeRestart(&lt_time);
lasttime=TimeState(&lt_time);
#else
lasttime=peek(0x40,0x6c);
#endif
rdebug_sendtrame("\x00",1); // Ok
}


// Traitement du systme de mise au point  distance
// Cette fonction est appele  chaque cycle
void rdebug_process(void)
{
// Pour grer l'avancement du traitement des messages
static unsigned phase;
static unsigned len;
static unsigned char crc;
extern int run;
// Calcul le nombre de cycles effctus par seconde
if(!run) cycleps=0;
else
	{
	extern unsigned word[];
	unsigned ctime;
	unsigned long calc;
	#ifdef LT
	ctime=TimeState(&lt_time);
	#else
	ctime=peek(0x40,0x6c);
	#endif
	calc=ctime-lasttime;
	#ifdef LT
	calc*=10lu;
	#else
	calc*=1000lu;
	calc/=182lu;
	#endif
	if(calc==0) calc=10000lu;
	else
		{
		calc=10000lu/calc;
		}
	cycleps=calc;
	lasttime=ctime;
	}
do
	{
	switch(phase)
		{
		case 0 : // Attente de l'entte
			{
			if(comint_ischar()) // Au moins un caractre en attente
				{
				if(comint_getcom()=='Z') // Le caractre d'entte ?
					{
					phase++; // Oui
					}
				else
					{
					return;
					}
				}
			else
				{
				return;
				}
			crc='Z';
			inittimout();
			}
		case 1 : // Attente de la longueur (partie basse)
			{
			if(comint_ischar()) // Au moins un caractre en attente
				{
				len=comint_getcom();
				crc+=len;
				phase++;
				}
			else
				{
				if(istimout())
					{
					phase=0;
					}
				return;
				}
			inittimout();
			}
		case 2 : // Attente de la longueur (partie haute)
			{
			if(comint_ischar()) // Au moins un caractre en attente
				{
				len|=(unsigned)comint_getcom()<<8;
				crc+=(len>>8);
				ltramein=0;
				phase++;
				}
			else
				{
				if(istimout())
					{
					phase=0;
					}
				return;
				}
			inittimout();
			}
		case 3 : // Attente du restant de la trame
			{
			if(comint_ischar())
				{
				tramein[ltramein]=comint_getcom();
				crc+=tramein[ltramein++];
				}
			else
				{
				if(istimout())
					{
					phase=0;
					}
				return;
				}
			inittimout();
			if(ltramein==len) phase++;
			else break;
			}
		case 4 : // Attente du crc
			{
			if(comint_ischar())
				{
				int charin;
				charin=comint_getcom();
				if((unsigned char)~crc==(unsigned char)charin)
					{ // CRC ok
					rdebug_processtrame();
					}
				else
					{
					}
				phase=0;
				}
			else
				{
				if(istimout())
					{
					phase=0;
					}
				return;
				}
			}
		}
	}
while(1);
}


#if defined(TEST) || defined(LTLOADER) || defined(FECLOADER)


int run;
int init;
int step;
#ifdef TEST
unsigned char in[NINPUT];
unsigned char out[NOUTPUT];
unsigned char bit[NBIT];
unsigned word[NWORD];
unsigned long dword[NDWORD];
float real[NFLOAT];
#endif

#ifdef LT
#include "c:\lt_prog\include\gesc2.h"
#include "c:\lt_prog\include\gesc1230.h"
TC1230 BlocAlimUC;

void SetUCLed(unsigned led)
{
BlocAlimUC.Led|=led;
}

void ResetUCLed(unsigned led)
{
BlocAlimUC.Led&=~led;
}

#endif



void main(void)
{
rdebug_init();
#ifdef LT
InsertionC2((unsigned int *)&BlocAlimUC,C1230,0);
// Allumer la led correspondant au port utilis
switch(RDEBUG_COM)
	{
	case 0 : SetUCLed(0x100); break;
	case 1 : SetUCLed(0x200); break;
	case 2 : SetUCLed(0x100); break;
	case 3 : SetUCLed(0x200); break;
	case 4 : SetUCLed(0x100); break;
	case 5 : SetUCLed(0x800); break;
	}
#ifdef LTLOADER
// Allumer la led prm
SetUCLed(8);
#endif
EcrCdg(0);
while(1)
#endif
#ifdef FECLOADER
while(1)
#else
while(!kbhit())
#endif
	{
	#if defined(LT) && defined(TEST)
	if(run)
		{
		BlocAlimUC.Led|=1;
		}
	else
		{
		BlocAlimUC.Led&=~1;
		}
	BlocAlimUC.Led|=2;
	#endif
	#ifdef LT
	RafraichissementEntree();
	#endif
	rdebug_process();
	#ifdef LT
	RafraichissementSortie();
	#endif
	}
#if !defined(LT) && !defined(FEC) && !defined(HC01)
comint_stopcom();
while(kbhit()) getch();
#endif
}
#endif
